<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Video extends Model {

    protected $casts = ['seconds' => 'object', 'ads_time' => 'object'];

    public function episode() {
        return $this->belongsTo(Episode::class);
    }

    public function item() {
        return $this->belongsTo(Item::class);
    }

    public function getAds() {
        $adsTime = [];
        if ($this->seconds) {
            $duration = $this->seconds;
            $videoAds = VideoAdvertise::get();
            for ($i = 0; $i < count($duration); $i++) {
                $videoAd = $videoAds->shuffle()->first();
                if ($videoAd->server) {
                    $general = gs();
                    $video   = $general->ftp->domain . '/' . $videoAd->content->video;
                } else {
                    $video = getImage(getFilePath('ads') . '/' . $videoAd->content->video);
                }
                $adsTime[$duration[$i]] = $videoAd->content->link ? $videoAd->content->link : $video;
            }
        }
        return $adsTime;
    }
}
